local assets =
{
    Asset("ANIM", "anim/hpup.zip"),
		Asset("ATLAS", "images/inventoryimages/hpup.xml"),
}

local prefabs =
{
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("hpup")
    inst.AnimState:SetBuild("hpup")
    inst.AnimState:PlayAnimation("idle")
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("edible")
    inst.components.edible.healthvalue = 10
    inst.components.edible.hungervalue = 0
    inst.components.edible.foodtype = FOODTYPE.VEGGIE

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "hpup"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/hpup.xml"
    inst:AddComponent("tradable")


    MakeHauntableLaunchAndPerish(inst)

    return inst
end

return Prefab("hpup", fn, assets, prefabs)